// TCScanDlg.h : header file
//
#include "drivers/ke2700.h"

#if !defined(AFX_TCSCANDLG_H__57AE1B9B_BC24_4364_85B8_2937FB487BC1__INCLUDED_)
#define AFX_TCSCANDLG_H__57AE1B9B_BC24_4364_85B8_2937FB487BC1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CTCScanDlg dialog

class CTCScanDlg : public CDialog
{
// Construction
public:

#define   TOTAL_READINS    10
#define   SCAN_CHANNEL_LIST      "101:110"  // make sure scan list size = multiple of total readings

	ViReal64   rdBuffer[80*TOTAL_READINS];
	ViPSession vi;
	ViStatus nErr;
    ViReal64  trigDelay;
	void DisplayError(ViSession sesn, ViStatus nErr);
	CTCScanDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CTCScanDlg)
	enum { IDD = IDD_TCSCAN_DIALOG };
	CListBox	m_listBox;
	CButton	m_startScan;
	CButton	m_setupScan;
	CString	m_resource;
	UINT	m_startChan;
	UINT	m_stopChan;
	CString	m_status;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTCScanDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CTCScanDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnInitialize();
	afx_msg void OnSetupScan();
	afx_msg void OnStartScan();
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TCSCANDLG_H__57AE1B9B_BC24_4364_85B8_2937FB487BC1__INCLUDED_)
